#include <Servo.h>
#include <Ultrasonic.h>
#include <Wire.h>
#include "SSD1306.h"
#include <ESP8266WiFi.h>  
#include "24s_PubSubClient.h"
#include "24s_WiFiManager.h"  
#include <math.h>

// Define the OLED display pins D14 SDA, D15 SCL
SSD1306 display(0x3C, D14, D15);

// Define the DC motor control signal pins
#define motor1pin D0 // GPIO pin setting for motor1 (right)
#define motor2pin D2 // GPIO pin setting for motor2 (left)
Servo motor1;       // Create servo motor1 object to control a servo
Servo motor2;       // Create servo motor2 object to control a servo

// Define ultrasonic sensors trig/control signals
Ultrasonic usonic_sensorF(D8, D5);
Ultrasonic usonic_sensorR(D9, D6);
Ultrasonic usonic_sensorL(D10, D7);
int distanceF; // Define variable
int distanceR;
int distanceL;
String distF; 
String mControl;

double posX, posY, prevX, prevY, desX, desY;
double angleRad, angleDeg;
double curMag, desMag, dot, VP;
int tempX, tempY;
int count = 0; //only job for this variable is to count up the array for the goal positions in the loop
String X, Y;
double goalX[5] = {1600, 2000, 110, 110, 700};
double goalY[5] = {130, 700, 600, 150, 130};
int turntimeL, turntimeR;

String angledegstr;
int MC2 = 90;
int turncount = 0;
int loopcount = 0;

//MQTT Communication associated variables
char payload_global[100];                     
boolean flag_payload;                         

//MQTT Setting variables  
const char* mqtt_server= "192.168.0.140";               //MQTT Broker(Server) Address
const char* MQusername = "user";               //MQTT username
const char* MQpassword = "Stevens1870";               //MQTT password
const char* MQtopic    = "louis_lidar_new";               //MQTT Topic (Arena I/II)
const int mqtt_port    = 1883;          //MQTT TCP/IP port number 

//WiFi Setting variables
const char* ssid     = "TP-Link_9402";                 //Wi-Fi SSID (Service Set IDentifier)   
const char* password = "77556578";                 //Wi-Fi Password

//WiFi Define
WiFiClient espClient;                         
PubSubClient client(espClient);             

// Function Definitions

void setup_wifi() { 
  delay(10);
  // We start by connecting to a Stevens WiFi network
  WiFi.begin(ssid, password);           
  while (WiFi.status() != WL_CONNECTED) {
    delay(500);
    Serial.print(".");                        
  }
  randomSeed(micros());                       
}

void callback(char* topic, byte* payload, unsigned int length) {
  for (int i = 0; i < length; i++) {
    payload_global[i] = (char)payload[i];
  }
  payload_global[length] = '\0';              
  flag_payload = true;                        
}

void reconnect() {                                                                
  // Loop until we're reconnected
  while (!client.connected()) {
    // Create a random client ID
    String clientId = "ESP8266Client-";       
    clientId += String(random(0xffff), HEX);  
    // Attempt to connect                     
    if (client.connect(clientId.c_str(),MQusername,MQpassword)) {
      client.subscribe(MQtopic);             
    } else {
      // Wait 5 seconds before retrying
      delay(5000);
    }
  }
}

void rotateleft(int time) // rotate left for "time" mil-sec
{
  MC2 = 180;
  motor1.write(180);
  motor2.write(180);
  delay(time); //480 90 deg
}

void rotateright(int time) // rotate right for "time" mil-sec
{
  MC2 = 0;
  motor1.write(0);
  motor2.write(0);
  delay(time); //510 90 deg

}

void turnaround () // rotate right for "time" mil-sec
{
  MC2 = 0;
  motor1.write(0);
  motor2.write(0);
  delay(1000);
  MC2 = 90;
  motor1.write(90);
  motor2.write(90);
  delay(100);
}

void forward() // move forward
{
  MC2 = 0;
  motor1.write(110);  //old fast values: 114
  motor2.write(67);   //60
}

void forwardSlow() // move forward
{
  MC2 = 0;
  motor1.write(100);
  motor2.write(77);
}

void correctR()
{
  MC2 = 46;
  motor1.write(105); //Old: 100, 50
  motor2.write(50);
}

void correctL()
{
MC2 = 56;
  motor1.write(130); //Old: 130, 75
  motor2.write(70);
}

void stop() // halt movement
{
  MC2 = 90;
  motor1.write(90);
  motor2.write(90);
}

void swerveL(){

  motor1.write(130);
  motor2.write(90);
  delay(50);
  forward();
  delay(500);
  stop();

}

void swerveR(){

  motor1.write(90);
  motor2.write(50);
  delay(50);
  forward();
  delay(500);
  stop();

}

void reverse(){

  motor1.write(60);
  motor2.write(120);
}


void dataCollect()
{
  //Wifi Connectons

if (!client.connected()) {
    Serial.print("...");
    reconnect();
  }
  client.loop();                              
  
  String payload(payload_global);              
  int testCollector[10];                      
  int count = 0;
  int prevIndex, delimIndex;
    
  prevIndex = payload.indexOf('[');           
  while( (delimIndex = payload.indexOf(',', prevIndex +1) ) != -1){
    testCollector[count++] = payload.substring(prevIndex+1, delimIndex).toInt();
    prevIndex = delimIndex;
  }
  delimIndex = payload.indexOf(']');
  testCollector[count++] = payload.substring(prevIndex+1, delimIndex).toInt();

//Robot location x,y from MQTT subscription variable testCollector 

  posX = testCollector[0];
  posY = testCollector[1];

  // Read and print sensor data
    distanceF = usonic_sensorF.read(CM) * 10; // read in MM
    distanceR = usonic_sensorR.read(CM) * 10;
    distanceL = usonic_sensorL.read(CM) * 10;
    //Serial.println(distanceF);
    distF = String(distanceF);          //converts integer to string
    angledegstr = String(angleDeg);
    X = String(posX);
    Y = String(posY);
    display.drawString(0, 0, "Group 6 'Geoff'");
    display.drawString(0, 15, "Distance MM");
    display.drawString(80, 15, distF);
    display.drawString(0, 30, "Angle:");
    display.drawString(80, 30, mControl);
    display.drawString(0, 45, "Coordinates:");
    display.drawString(65, 45, X);
    display.drawString(100, 45, Y);
    display.display();
    display.clear();

}

void dataCollectPrev()
{
  //Wifi Connectons

if (!client.connected()) {
    Serial.print("...");
    reconnect();
  }
  client.loop();                              
  
  String payload(payload_global);              
  int testCollectorP[10];                      
  int count = 0;
  int prevIndex, delimIndex;
    
  prevIndex = payload.indexOf('[');           
  while( (delimIndex = payload.indexOf(',', prevIndex +1) ) != -1){
    testCollectorP[count++] = payload.substring(prevIndex+1, delimIndex).toInt();
    prevIndex = delimIndex;
  }
  delimIndex = payload.indexOf(']');
  testCollectorP[count++] = payload.substring(prevIndex+1, delimIndex).toInt();

//Robot location x,y from MQTT subscription variable testCollector 

  prevX = testCollectorP[0];
  prevY = testCollectorP[1];
}


void calcAngle()
{

desX = goalX[count];
desY = goalY[count];

curMag = sqrt( ((posX - prevX)*(posX - prevX)) + ((posY - prevY)*(posY - prevY)));
desMag = sqrt( ((desX - posX)*(desX - posX)) + ((desY - posY)*(desY - posY)));

dot = ( ((posX - prevX)*(desX - posX)) + ((posY - prevY)*(desY - posY)) );

angleRad = acos( dot / ((abs(curMag))*(abs(desMag))) );

if (angleRad > 0){
angleDeg = angleRad * (180/3.14159265358979323846);

VP = ( ((posX - prevX)*(desY - posY)) - ((posY - prevY)*(desX - posX)) );

turntimeR = angleDeg * 2;
turntimeL = angleDeg * 2;
}

else{
  angleDeg = 0;
  turntimeR = 0;
  turntimeL = 0;
  }

}





void setup()
{

  Serial.begin(115200);
  delay(1000);

  //Connect to wifi
  setup_wifi();                               
  delay(1000);
  Serial.println("Wemos POWERING UP ......... ");
  client.setServer(mqtt_server, mqtt_port);          //This 1883 is a TCP/IP port number for MQTT 
  client.setCallback(callback); 

//motor setup
    motor1.attach(motor1pin); // motor1 is attached using the motor1pin
    motor2.attach(motor2pin); // motor2 is attached using the motor2pin

  //OLED Setup
    display.init();
    display.flipScreenVertically();
    display.setFont(ArialMT_Plain_10);
    display.display();

  

  dataCollectPrev();

  delay(400);

  forward();
  delay(2000);
  stop();
  delay(500);
  rotateleft(300);
  stop();
  forward();
  delay(1000);
  stop();

  dataCollect();

  delay(500);

}


void loop()
{


calcAngle();

Serial.println(distanceF);

dataCollectPrev();

forward();

if (desMag > 370){

if (angleDeg > 40 && distanceF >= 61 && distanceR >= 60 && distanceL >= 60){
  if (VP < 0){
    rotateright(turntimeR);
    forward();
    }
  if (VP > 0){
    rotateleft(turntimeL);
    forward();
  }
}

if (angleDeg <= 40 && distanceF >= 61 && distanceR >= 60 && distanceL >= 60) {
    forward();
}

if (distanceF < 61 || distanceR < 60 || distanceL < 60){

  if (distanceR < 60 && distanceF < 61 && distanceL > 60){
    rotateleft(300);
    forward();
  }

  if (distanceL < 60 && distanceF < 61 && distanceR > 60){
    rotateright(300);
    forward();
    }
  
  if (distanceF < 61 && distanceR > 60 && distanceL > 60){
    rotateleft(300);
    forward();
    }

  if (distanceR < 60 && distanceF > 61 && distanceL > 60){
    correctL();
  }

  if (distanceR > 60 && distanceF > 61 && distanceL < 60){
    correctR();
   }

   if (distanceL < 60 && distanceF < 61 && distanceR < 60){
     reverse();
   }

   if (distanceL < 60 && distanceR < 60 && distanceF > 61){
     forward();
   }
  }
}




if (desMag <= 370){

if (angleDeg > 25 && distanceF >= 61 && distanceR >= 60 && distanceL >= 60 && desMag > 100){
  if (VP < 0){
    rotateright(turntimeR);
    forwardSlow();
    delay(100);
    }
  if (VP > 0){
    rotateleft(turntimeL);
    forwardSlow();
    delay(100);

  }
}

if (angleDeg <= 25 && distanceF >= 61 && distanceR >= 60 && distanceL >= 60 && desMag > 100) {
    forwardSlow();
    delay(100);
}

if (distanceF < 61 || distanceR < 60 || distanceL < 60 && desMag > 100){
  if (distanceR < 60 && distanceF < 61 && distanceL > 60){
        rotateleft(300);
        forwardSlow();
        delay(100);
       }

  if (distanceL < 60 && distanceF < 61 && distanceR > 60){
        rotateright(300);
        forwardSlow();
        delay(100);
        }
  
  if (distanceF < 61 && distanceR > 60 && distanceL > 60){
    rotateleft(300);
    forwardSlow();
    delay(100);
  }

  if (distanceR < 60 && distanceF > 61 && distanceL > 60){
    correctL();
    delay(100);
  }

  if (distanceR > 60 && distanceF > 61 && distanceL < 60){
    correctR();
    delay(100);
   }

   if (distanceL < 60 && distanceF < 61 && distanceR < 60){
     reverse();
     delay(100);
   }

   if (distanceL < 60 && distanceR < 60 && distanceF > 61){
     forwardSlow();
     delay(100);
   }
  }

}

if (desMag <= 100){
  count = count + 1;
  delay(3000); 
}


if (count >= 5){
  delay(1000000000);
}

dataCollect();


}




